/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnectorListener;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Logger.LocalizedInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public abstract class BlockConnector
implements Serializable,
Storable,
EqualsCheck,
LocalizedInfo {
    static final long serialVersionUID = 2673797346620109943L;
    private int onDelayBlockSerializedDataVersion = 1;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int BINARY = 0;
    public static final int ANALOG = 1;
    public static final int PARAMETER = 2;
    protected Block fOwner = null;
    protected String fConnectorName = "";
    private transient Vector fValueChangedListener;
    protected boolean fVisible = true;
    protected boolean fConnectable = true;
    protected boolean fNegated = false;

    public void addValueChangedListener(BlockConnectorListener listener) {
        this.getValueChangedListener().add(listener);
    }

    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BlockConnector otherConnector = (BlockConnector)other;
        Block owner = this.getOwner();
        Block otherOwner = otherConnector.getOwner();
        if (owner == null || otherOwner == null) {
            return owner == otherOwner;
        }
        if (owner != otherOwner) {
            if (owner.getClass() != otherOwner.getClass()) {
                return false;
            }
            if (owner.getClass() == DeputyBlock.class && otherOwner.getClass() == DeputyBlock.class ? ((DeputyBlock)owner).getParent().getGuid() != ((DeputyBlock)otherOwner).getParent().getGuid() || ((DeputyBlock)owner).getParent().getGuid() == ((DeputyBlock)otherOwner).getParent().getGuid() && ((DeputyBlock)owner).getIndexOfParentUDF() != ((DeputyBlock)otherOwner).getIndexOfParentUDF() : owner.getNumber() != otherOwner.getNumber()) {
                return false;
            }
        }
        return !(this instanceof InBlockConnector ? owner.getInConnectorPosition((InBlockConnector)this) != otherOwner.getInConnectorPosition((InBlockConnector)otherConnector) : owner.getOutConnectorPosition((OutBlockConnector)this) != otherOwner.getOutConnectorPosition((OutBlockConnector)otherConnector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireValueChanged() {
        if (this.fValueChangedListener != null) {
            Vector l;
            BlockConnector blockConnector = this;
            synchronized (blockConnector) {
                l = (Vector)this.fValueChangedListener.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ((BlockConnectorListener)l.elementAt(i)).connectorValueChanged(this);
            }
        }
    }

    public Block getOwner() {
        return this.fOwner;
    }

    public void setOwner(Block block) {
        this.fOwner = block;
    }

    public String getName() {
        if ((this.fConnectorName == null || this.fConnectorName.equals("")) && this.fOwner != null) {
            return this.fOwner.getNumberString();
        }
        return this.fConnectorName;
    }

    private Vector getValueChangedListener() {
        if (this.fValueChangedListener == null) {
            this.fValueChangedListener = new Vector();
        }
        return this.fValueChangedListener;
    }

    public boolean isConnectable() {
        return this.fConnectable;
    }

    public void setNegated(boolean negate) throws UnsupportedOperationException {
        this.fNegated = negate;
    }

    public boolean isNegatable() {
        return false;
    }

    public boolean isNegated() throws UnsupportedOperationException {
        return this.fNegated;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void read(StorableInput dr) throws IOException {
        this.fConnectorName = dr.readString();
        this.fOwner = (Block)dr.readStorable();
        this.fConnectable = dr.readBoolean();
        this.fVisible = dr.readBoolean();
        this.fNegated = dr.readBoolean();
    }

    public void setConnectable(boolean newConnectable) {
        this.fConnectable = newConnectable;
    }

    public void setName(String name) {
        this.fConnectorName = name;
    }

    public void setVisible(boolean newVisible) {
        this.fVisible = newVisible;
    }

    protected void setWiringDiagramModified() {
        if (this.getOwner() != null && this.getOwner().getWiringDiagram() != null) {
            this.getOwner().getWiringDiagram().setModified(true);
        }
    }

    public String toString() {
        String name = this.getName();
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46));
        Block owner = this.getOwner();
        StringBuffer buffer = new StringBuffer();
        buffer.append(className).append(" ").append(name).append(" an ").append(owner).append(" - ").append(owner.getNumberString());
        return buffer.toString();
    }

    public void write(StorableOutput dw) {
        dw.writeString(this.fConnectorName);
        dw.writeStorable(this.fOwner);
        dw.writeBoolean(this.fConnectable);
        dw.writeBoolean(this.fVisible);
        dw.writeBoolean(this.fNegated);
    }

    public abstract int getSignalType();

    public abstract int getInputOutputType();

    public abstract int getLinkedConnectorsCount();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.fConnectorName == null) {
            this.fConnectorName = "";
        }
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        return true;
    }

    public String getLocalizedName(boolean longDescription) {
        if (longDescription) {
            String blockName;
            String s = this.getName();
            if (!s.equals(blockName = this.getOwner().getNumberString())) {
                return blockName + "/" + s;
            }
            return blockName;
        }
        return this.getName();
    }

    public String getLocalizedNameOptimized() {
        if (this instanceof InBlockConnector) {
            String blockName;
            String s = this.getName();
            if (!s.equals(blockName = this.getOwner().getNumberString()) && this.getOwner().getInConnectorCount() > 1) {
                return blockName + "/" + s;
            }
            return blockName;
        }
        return this.getLocalizedName(true);
    }

    public abstract int getConnectorPosition();
}

